/*
*******************************************************************************
*
* File:         pxblkdef.h
* Description:  
* Author:       Henrik Liebau
* Created:      05 Apr 2000, 17:14:38
* Modified:     Thu May 31 17:24:27 2001 by Henrik Liebau, BVS R&D
* Language:     C/C++ Include File
* Package:      
* Status:       
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/
 
#ifndef __pxblkdef_H__
#define __pxblkdef_H__

CLI typedef enum _bxppr_riblkpermtype {
  BXPPR_RIBLKPERM_DIRECTION,			/* @direction */
  BXPPR_RIBLKPERM_BUSADDR_LO,			/* @busaddrlo */
  BXPPR_RIBLKPERM_BUSADDR_HI,			/* @busaddrhi */
  BXPPR_RIBLKPERM_INTADDR,			/* @intaddr */
  BXPPR_RIBLKPERM_RESOURCE,			/* @resource */
  BXPPR_RIBLKPERM_BLOCKSIZE,			/* @blocksize */
  BXPPR_RIBLKPERM_FILLGAPS,			/* @fillgaps */
  BXPPR_RIBLKPERM_FIRSTPERM,			/* @firstperm */
  BXPPR_RIBLKPERM_STARTOFFSET,			/* @startoffset */
  BXPPR_RIBLKPERM_SIZELIMIT,			/* @sizelimit */
  BXPPR_RIBLKPERM_TUPLES,			/* @tuples */
  BXPPR_RIBLKPERM_ENUMSIZE			/* $enumsize */
} bxppr_riblkpermtype;

CLI typedef enum _bxppr_riblktype {
  BXPPR_RIBLK_ALIGN = BX_RIBLK_BUSADDR_LO,	/* @align (basically related to busaddress, will be overridden later) */
  BXPPR_RIBLK_BUSCMD     = BX_RIBLK_BUSCMD,	/* @buscmd */
  BXPPR_RIBLK_BYTEN      = BX_RIBLK_BYTEN,	/* @byten */
  BXPPR_RIBLK_NUMBYTES   = BX_RIBLK_NUMBYTES,	/* @numbytes */
  BXPPR_RIBLK_RELAXORDER = BX_RIBLK_RELAXORDER, /* @relaxorder */
  BXPPR_RIBLK_NOSNOOP    = BX_RIBLK_NOSNOOP,	/* @nosnoop */
  BXPPR_RIBLK_ENUMSIZE				/* $enumsize */
} bxppr_riblktype;

CLI typedef enum _bxppr_riblkresulttype {
  BXPPR_RIBLKRES_LASTPERM,			/* @lastperm */
  BXPPR_RIBLKRES_ACTUALSIZE,			/* @actualsize */
  BXPPR_RIBLKRES_TIME,				/* @time */
  BXPPR_RIBLKRES_TUPLES_TIME,			/* @tuplestime */
  BXPPR_RIBLKRES_NUMGAPS,			/* @numgaps */
  BXPPR_RIBLKRES_NUMSKIPPED,			/* @numskipped */
  BXPPR_RIBLKRES_ENUMSIZE			/* $enumsize */
} bxppr_riblkresulttype;

CLI typedef enum _bxppr_riblkgaptype {
  BXPPR_RIBLKGAP_BUSADDR,			/* @busaddr */
  BXPPR_RIBLKGAP_BUSADDRHI,			/* @busaddrhi */
  BXPPR_RIBLKGAP_BUSCMD,			/* @buscmd */
  BXPPR_RIBLKGAP_BYTEN,				/* @byten */
  BXPPR_RIBLKGAP_NUMBYTES,			/* @numbytes */
  BXPPR_RIBLKGAP_ENUMSIZE			/* $enumsize */
} bxppr_riblkgaptype;

CLI /* DEF_START ~G_BXPPR_RIBLKPERM_DIRECTION */
#define BXPPR_RIBLKPERM_DIRECTION_READ      0x000   /* @read */
#define BXPPR_RIBLKPERM_DIRECTION_WRITE     0x001   /* @write */
#define BXPPR_RIBLKPERM_DIRECTION_READCOMPARE 0x002   /* @readcompare */
#define BXPPR_RIBLKPERM_DIRECTION_WRITEREADCOMPARE 0x003   /* @writereadcompare */
CLI /* DEF_END */

CLI /* DEF_START ~G_BXPPR_RIBLKPERM_SIZELIMIT */
#define BXPPR_RIBLKPERM_SIZELIMIT_NOLIMIT   0x000   /* @nolimit */
CLI /* DEF_END */

#endif
